"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAllFromScroll = void 0;
var _lodash = require("lodash");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const fetchAllFromScroll = async ({
  clusterClient,
  scroll,
  request,
  response
}) => {
  let hits = (0, _lodash.get)(response, 'hits.hits', []);
  let scrollId = (0, _lodash.get)(response, '_scroll_id');
  const allHits = [...hits];
  if (hits.length) {
    while (true) {
      const promisedResp = await clusterClient.asScoped(request).asCurrentUser.scroll({
        body: {
          scroll,
          scroll_id: scrollId
        }
      });
      hits = (0, _lodash.get)(promisedResp, 'hits.hits', []);
      if (!hits.length) {
        return allHits;
      }
      scrollId = (0, _lodash.get)(promisedResp, '_scroll_id');
      allHits.push(...hits);
    }
  }
  return allHits;
};
exports.fetchAllFromScroll = fetchAllFromScroll;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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